// IFDL Auxillary Procedure
//  1998 WaveMetrics, Inc. all rights reserved
//
// To use, type:
// #include ":IFDL Procedures:Apply Filter"
// in your procedure window.

#pragma version=3.1
#pragma rtGlobals=1		// Use modern global access method.

Macro ApplyFilterToData(data,filter,delay,graphResult)	
	String data,filter
	Variable graphResult,delay
	Prompt data "data wave",popup WaveList("*",";","")
	Prompt filter "filter coefficient wave",popup WaveList("*",";","")
	Prompt delay "filtered output",popup, "not delayed;delayed"
	Prompt graphResult "graph data and filtered signal?",popup, "Yes;No;"

	PauseUpdate;Silent 1	// Apply Filter To Data...
	Variable dataFs= 1/ deltax($data)
	Variable filterFs= 1/ deltax($filter)

	if((dataFs/filterFs < 0.999)+(dataFs/filterFs > 1.001))	// +/- .1% sample rate mismatch
		// data frequency will be imposed on filter, warn user
		String msg
		sprintf msg, "Filter %s sampling frequency (%g) doesn't match %s (%g).",filter,filterFs,data,dataFs
		DoAlert 1, msg+"\rProceeding will scale filter to match data. Filter anyway?"
		if( V_Flag != 1 )
			return
		endif
		Print "WARNING: "+filter+" sampling frequency does not match "+data
		Print "\t"+filter+" sampling frequency= ",filterFS
		Print "\t"+data+" sampling frequency= ",dataFS
		Print "\t"+filter+" frequencies will be scaled by ",dataFs/filterFs
	endif
	String dupName= CleanupName(data+"Filt",1)
	Duplicate/O $data, $dupName
	
	Variable filtLeftx= leftx($filter)
	Variable filtDeltax= deltax($filter)
	if( delay == 1 )	// force acausal convolution
		Variable offset= - trunc((numpnts($filter)-1)/2)/deltax($filter)
		SetScale/P x, offset, filtDeltax, "", $filter
	endif
	FilterConvolution($filter,$dupName)
	if( delay == 1 )	// restore filter scaling
		SetScale/P x, filtLeftx, filtDeltax, "", $filter
	endif
	if( graphResult == 1 )
		CheckDisplayed/A $dupName
		if( V_Flag == 0 )
			Display $data, $dupName
			ModifyGraph rgb($dupName)=(0,0,65535)	// blue
			Legend ""
		endif
	endif
End	

Function FilterConvolution(sw,dw)
	Wave sw,dw
	
	if( leftx(sw) < 0 )
		Convolve/A sw,dw
	else
		Variable n= numpnts(dw)
		Variable halfFilterLen= trunc((numpnts(sw)-1)/2)
		Convolve sw,dw
		Redimension/N=(n+halfFilterLen) dw
	endif
	return 0
end
